<?php
// ?? Database config
$host = "localhost";
$dbname = "amstapay";
$username = "root";
$password = "";

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    // Log error (optional)
    file_put_contents("log.txt", "DB ERROR: " . $e->getMessage() . PHP_EOL, FILE_APPEND);

    echo json_encode([
        "status" => "error",
        "message" => "Database error: " . $e->getMessage()
    ]);
    exit; // ?? Stop execution if DB connection fails
}
?>
