<?php
include "phpqrcode/phpqrcode.php";

// Account details
$accountName   = "John Doe";
$accountNumber = "0123456789";
$bankName      = "Access Bank";
$data = "Account Name: $accountName\nAccount Number: $accountNumber\nBank: $bankName";

// Temporary QR file
$qrFile = "account-qr.png";
QRcode::png($data, $qrFile, QR_ECLEVEL_H, 10); // use high error correction (H)

// Load QR and logo
$qrImage   = imagecreatefrompng($qrFile);
$logoImage = imagecreatefrompng("logo.png"); // your logo file (PNG)

// Get dimensions
$qrWidth   = imagesx($qrImage);
$qrHeight  = imagesy($qrImage);
$logoWidth = imagesx($logoImage);
$logoHeight= imagesy($logoImage);

// Scale logo to fit 1/5 of QR code
$logo_qr_width  = $qrWidth/5;
$scale          = $logoWidth/$logo_qr_width;
$logo_qr_height = $logoHeight/$scale;

// Calculate position (center)
$posX = ($qrWidth - $logo_qr_width) / 2;
$posY = ($qrHeight - $logo_qr_height) / 2;

// Merge logo onto QR
imagecopyresampled(
    $qrImage, $logoImage,
    $posX, $posY, 0, 0,
    $logo_qr_width, $logo_qr_height,
    $logoWidth, $logoHeight
);


// Output final image
header('Content-Type: image/png');
imagepng($qrImage);

// Clean up
imagedestroy($qrImage);
imagedestroy($logoImage);

 ?>
<?php
/*include "phpqrcode/phpqrcode.php";

// Account details
$accountName   = "John Doe";
$accountNumber = "0123456789";
$bankName      = "Access Bank"; // optional

// The data to encode (what shows when someone scans)
$data = "Account Name: $accountName\nAccount Number: $accountNumber\nBank: $bankName";
/**
* 
// Generate QR into a temporary file
$qrFile = "account-qr.png";
QRcode::png($data, $qrFile, QR_ECLEVEL_H, 8);

// Load the QR
$qrImage = imagecreatefrompng($qrFile);

// Get QR size
$qrWidth  = imagesx($qrImage);
$qrHeight = imagesy($qrImage);
**.

// Temporary QR file
$qrFile = "account-qr.png";
QRcode::png($data, $qrFile, QR_ECLEVEL_H, 10); // use high error correction (H)

// Load QR and logo
$qrImage   = imagecreatefrompng($qrFile);
$logoImage = imagecreatefrompng("logo.png"); // your logo file (PNG)

// Get dimensions
$qrWidth   = imagesx($qrImage);
$qrHeight  = imagesy($qrImage);
$logoWidth = imagesx($logoImage);
$logoHeight= imagesy($logoImage);

// Scale logo to fit 1/5 of QR code
$logo_qr_width  = $qrWidth/5;
$scale          = $logoWidth/$logo_qr_width;
$logo_qr_height = $logoHeight/$scale;

// Calculate position (center)
$posX = ($qrWidth - $logo_qr_width) / 2;
$posY = ($qrHeight - $logo_qr_height) / 2;


// Create new image canvas (add extra space for text above and below)
$padding = 30; // space for text
$totalHeight = $qrHeight + ($padding * 2);
$finalImage = imagecreatetruecolor($qrWidth, $totalHeight);

// Colors
$white = imagecolorallocate($finalImage, 255, 255, 255);
$black = imagecolorallocate($finalImage, 0, 0, 0);

// Fill background white
imagefill($finalImage, 0, 0, $white);

// Copy QR into the middle
imagecopy($finalImage, $qrImage, 0, $padding, 0, 0, $qrWidth, $qrHeight);
// Merge logo onto QR
imagecopyresampled(
    $finalImage, $logoImage,
    $posX, $posY, 0, 0,
    $logo_qr_width, $logo_qr_height,
    $logoWidth, $logoHeight
);
// Add text (using built-in GD font)
$font = 100; // built-in font size
// Center top text
$topText = $accountName;
$topX = ($qrWidth - imagefontwidth($font) * strlen($topText)) / 2;
imagestring($finalImage, $font, $topX, 50, $topText, $black);

// Helper: auto-scale text
function fitTextToWidth($text, $maxWidth, $fontFile, $fontSize) {
    do {
        $bbox = imagettfbbox($fontSize, 0, $fontFile, $text);
        $textWidth = $bbox[2] - $bbox[0];
        if ($textWidth > $maxWidth) {
            $fontSize--;
        } else {
            break;
        }
    } while ($fontSize > 5);
    return $fontSize;
}
// Center bottom text
$bottomText = $accountNumber;
$bottomX = ($qrWidth - imagefontwidth($font) * strlen($bottomText)) / 2;
imagestring($finalImage, $font, $bottomX, $qrHeight + $padding, $bottomText, $black);

// Output final image
header('Content-Type: image/png');
imagepng($finalImage);

// Cleanup
imagedestroy($qrImage);
imagedestroy($finalImage);
**/?>


?>
<!doctype html>
<html>
<head>
<title>qr test </title>
</head>
<body>
<img src="account-qr.png" />
</body>
</html>
