<?php
header("Content-Type: application/json");

require 'PHPMailer-master/src/Exception.php';
require 'PHPMailer-master/src/PHPMailer.php';
require 'PHPMailer-master/src/SMTP.php';

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

//  Capture raw input
$rawInput = file_get_contents("php://input");
//file_put_contents("log.txt", $rawInput . PHP_EOL, FILE_APPEND);

$data = json_decode($rawInput, true);

//  Fallback: if not JSON, check $_POST
if (!$data) {
    $data = $_POST;
}

//  Ensure we got something
if (!$data) {
    echo json_encode(["status" => "error", "message" => "No valid input received"]);
    exit;
}else{

if(isset($data["signupType"])){
	
//  Handle signup

  $accountType = isset($data["signupType"]) ? trim($data["signupType"]) : "Personal-signup";

if($accountType=='Personal-signup'){
	
personalsignup($data);

}
if($accountType=='Business-signup'){
	
companysignup($data);

}
}
	
}

function personalsignup($data) {
try{
	
	require('dbcon.php');
        //  Collect fields
        $firstname   = isset($data["firstname"]) ? trim($data["firstname"]) : "";
        $phone       = isset($data["phone"]) ? trim($data["phone"]) : "";
        $email       = isset($data["email"]) ? trim($data["email"]) : "";
        $passwordVal = isset($data["password"]) ? trim($data["password"]) : "";
        $accountType = isset($data["signupType"]) ? trim($data["signupType"]) : "Personal-signup";

        //  Validate required fields
        if (empty($firstname) || empty($phone) || empty($email) || empty($passwordVal)) {
            echo json_encode(["status" => "error", "message" => "All fields are required"]);
            exit;
        }

        $date = date('Y-m-d H:i:s');
        $verificationCode = rand(10000000, 99999999);
        $passwordHash = md5($passwordVal);

        //  Check if user exists
        $user_check = $pdo->prepare("SELECT id FROM users WHERE email = :email");
        $user_check->execute([":email" => $email]);
        
        if ($user_check->rowCount() > 0) {
            echo json_encode(["status" => "failed", "message" => "Email Already Exist"]);
            exit;
        }

        //  Insert new user
        $stmt = $pdo->prepare("INSERT INTO users (name, phone, email, password, type, verificationcode, date) 
                               VALUES (:firstname, :phone, :email, :password, :accountType, :verificationcode, :date)");
        $stmt->execute([
            ":firstname" => $firstname,
            ":phone" => $phone,
            ":email" => $email,
            ":password" => $passwordHash,
            ":accountType" => $accountType,
            ":verificationcode" => $verificationCode,
            ":date" => $date,
        ]);

        echo json_encode(["status" => "success", "message" => "User registered successfully"]);

    } catch (PDOException $e) {
        // Log error (optional)
        file_put_contents("log.txt", "DB ERROR: " . $e->getMessage() . PHP_EOL, FILE_APPEND);

        echo json_encode([
            "status" => "error",
            "message" => "Database error: " . $e->getMessage()
        ]);
        exit;
    }
}

function companysignup($data) {
try{
	require('dbcon.php');
        //  Collect fields
        $firstname   = isset($data["firstname"]) ? trim($data["firstname"]) : "";
        $phone       = isset($data["phone"]) ? trim($data["phone"]) : "";
        $email       = isset($data["email"]) ? trim($data["email"]) : "";
        $passwordVal = isset($data["password"]) ? trim($data["password"]) : "";
        $accountType = isset($data["signupType"]) ? trim($data["signupType"]) : "Personal-signup";

        //  Validate required fields
        if (empty($firstname) || empty($phone) || empty($email) || empty($passwordVal)) {
            echo json_encode(["status" => "error", "message" => "All fields are required"]);
            exit;
        }

        $date = date('Y-m-d H:i:s');
        $verificationCode = rand(10000000, 99999999);
        $passwordHash = password_hash($passwordVal, PASSWORD_BCRYPT);

        //  Check if user exists
        $user_check = $pdo->prepare("SELECT id FROM users WHERE email = :email");
        $user_check->execute([":email" => $email]);
        
        if ($user_check->rowCount() > 0) {
            echo json_encode(["status" => "failed", "message" => "Email Already Exist"]);
            exit;
        }

        //  Insert new user
        $stmt = $pdo->prepare("INSERT INTO users (name, phone, email, password, type, verificationcode, date) 
                               VALUES (:firstname, :phone, :email, :password, :accountType, :verificationcode, :date)");
        $stmt->execute([
            ":firstname" => $firstname,
            ":phone" => $phone,
            ":email" => $email,
            ":password" => $passwordHash,
            ":accountType" => $accountType,
            ":verificationcode" => $verificationCode,
            ":date" => $date,
        ]);

        echo json_encode(["status" => "success", "message" => "User registered successfully"]);

    } catch (PDOException $e) {
        // Log error (optional)
        file_put_contents("log.txt", "DB ERROR: " . $e->getMessage() . PHP_EOL, FILE_APPEND);

        echo json_encode([
            "status" => "error",
            "message" => "Database error: " . $e->getMessage()
        ]);
        exit;
    }
}

?>
